package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewUploadPhotoOverlayBinding
import ai.engagely.openbot.model.constants.ServerConstants
import ai.engagely.openbot.model.pojos.internal.chat.IFileItem
import ai.engagely.openbot.model.pojos.internal.chat.IVideoItem
import ai.engagely.openbot.model.pojos.internal.livechat.ILiveChatMediaData
import ai.engagely.openbot.model.utils.general.ImageUtils
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout
import androidx.core.content.ContextCompat

class UploadMediaOverlayView : FrameLayout {

    private var binding: ViewUploadPhotoOverlayBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewUploadPhotoOverlayBinding.inflate(LayoutInflater.from(context), this, true)

        binding?.ibClose?.setOnClickListener {
            this.visibility = GONE
        }

        binding?.messageUnderline?.setColor(ContextCompat.getColor(context, R.color.white))
    }

    fun setData(data: ILiveChatMediaData?, themeColor: Int, onClickListener: OnClickListener) {
        data?.uploadedUrl?.let { uploadedUrl ->
            if (ServerConstants.LIVE_CHAT_MEDIA_TYPE_IMAGE == data.mediaType) {
                binding?.ivPhotoToBeSent?.let { ivPhotoToBeSent ->
                    ImageUtils.loadImage(context, uploadedUrl, ivPhotoToBeSent)
                }
                setMediaVisibility(
                    photoVisibility = VISIBLE,
                    videoVisibility = GONE,
                    fileVisibility = GONE
                )
            } else if (ServerConstants.LIVE_CHAT_MEDIA_TYPE_VIDEO == data.mediaType) {
                binding?.videoToBeSent?.setData(
                    iVideoItem = IVideoItem(
                        title = null,
                        description = null,
                        fileSize = null,
                        url = uploadedUrl,
                        hideDetails = true,
                        hideSideSpaces = true,
                        date = null,
                        isBotItem = false,
                        isHistoryItem = false
                    ), onItemClickListener = onClickListener
                )
                setMediaVisibility(
                    photoVisibility = GONE,
                    videoVisibility = VISIBLE,
                    fileVisibility = GONE
                )
            } else if (ServerConstants.LIVE_CHAT_MEDIA_TYPE_FILE == data.mediaType) {
                binding?.fileView?.setData(
                    iFileItem = IFileItem(
                        fileUrl = uploadedUrl,
                        fileSize = null,
                        fileSizeString = data.mediaSize,
                        fileName = data.mediaName ?: "",
                        hideSideSpaces = true,
                        date = null,
                        isBotItem = false,
                        isHistoryItem = false
                    ),
                    themeColor = themeColor,
                    itemClickListener = onClickListener
                )
                setMediaVisibility(
                    photoVisibility = GONE,
                    videoVisibility = GONE,
                    fileVisibility = VISIBLE
                )
            } else {
                setMediaVisibility(
                    photoVisibility = GONE,
                    videoVisibility = GONE,
                    fileVisibility = GONE
                )
            }
        }
        binding?.ibSend?.tag = data
        binding?.ibSend?.setOnClickListener(onClickListener)
        setIsLoading(true == data?.isUploading)

        binding?.ibSend?.visibility = if (true == data?.isSendingMessage) GONE else VISIBLE
        binding?.pbSending?.visibility = if (true == data?.isSendingMessage) VISIBLE else GONE

        if (true == data?.clearMessage) {
            binding?.etMessage?.setText("")
        }

        this.visibility = if (true == data?.showPreview) VISIBLE else GONE
    }

    private fun setMediaVisibility(
        photoVisibility: Int,
        videoVisibility: Int,
        fileVisibility: Int
    ) {
        binding?.ivPhotoToBeSent?.visibility = photoVisibility
        binding?.videoToBeSent?.visibility = videoVisibility
        binding?.fileView?.visibility = fileVisibility
    }

    private fun setIsLoading(loading: Boolean) {
        binding?.pbLoading?.visibility = if (loading) VISIBLE else GONE
        binding?.vMediaToBeSentContainer?.visibility = if (loading) GONE else VISIBLE
        binding?.etMessage?.visibility = if (loading) GONE else VISIBLE
        binding?.ibSendContainer?.visibility = if (loading) GONE else VISIBLE
        binding?.messageUnderline?.visibility = if (loading) GONE else VISIBLE
    }

    fun getMessage(): String? {
        return binding?.etMessage?.text?.toString()?.ifBlank { null }
    }
}