package ai.engagely.openbot.model.pojos.internal.chat

import ai.engagely.openbot.model.pojos.internal.livechat.ILiveChatDataContainer
import java.util.*

class ILiveChatStatusItem(
    val statusMessage: String,
    val status: ILiveChatDataContainer.ILiveChatStatus,
    date: Date? = null,
    isLoading: Boolean = false,
    isBotItem: Boolean = false,
    isHistoryItem: Boolean = false,
    uuid: String = UUID.randomUUID().toString(),
    pendingData: Any? = null
) : IChatItem(date, isLoading, isBotItem, isHistoryItem, uuid, pendingData) {
    override fun makeACopy(): IChatItem {
        return ILiveChatStatusItem(
            statusMessage = statusMessage,
            status = status,
            date = date,
            isLoading = isLoading,
            isBotItem = isBotItem,
            isHistoryItem = isHistoryItem,
            uuid = uuid,
            pendingData = pendingData
        )
    }
}