package ai.engagely.openbot.model.pojos.internal.chat

import java.util.*

class IYouTubeVideoItem(
    val title: String?,
    val description: String?,
    val url: String,
    date: Date?,
    isBotItem: Boolean,
    isHistoryItem: Boolean,
    uuid: String = UUID.randomUUID().toString(),
    pendingData: Any? = null
) : IChatItem(
    date = date,
    isBotItem = isBotItem,
    isHistoryItem = isHistoryItem,
    uuid = uuid,
    pendingData = pendingData
) {
    override fun makeACopy(): IChatItem {
        return IYouTubeVideoItem(
            title = title,
            description = description,
            url = url,
            date = date,
            isBotItem = isBotItem,
            isHistoryItem = isHistoryItem,
            uuid = uuid,
            pendingData = pendingData
        )
    }
}