package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewUploadPhotoOverlayBinding
import ai.engagely.openbot.model.constants.ServerConstants
import ai.engagely.openbot.model.pojos.internal.chat.IFileItem
import ai.engagely.openbot.model.pojos.internal.chat.IVideoItem
import ai.engagely.openbot.model.pojos.internal.livechat.ILiveChatMediaData
import ai.engagely.openbot.model.pojos.internal.livechat.ILiveChatMediaUploadFailure
import ai.engagely.openbot.model.utils.general.ImageUtils
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout
import androidx.core.content.ContextCompat

class UploadMediaOverlayView : FrameLayout {

    private var binding: ViewUploadPhotoOverlayBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewUploadPhotoOverlayBinding.inflate(LayoutInflater.from(context), this, true)

        binding?.ibClose?.setOnClickListener {
            this.visibility = GONE
        }

        binding?.messageUnderline?.setColor(ContextCompat.getColor(context, R.color.white))
    }

    fun setData(data: ILiveChatMediaData?, themeColor: Int, onClickListener: OnClickListener) {
        data?.uploadedUrl?.let { uploadedUrl ->
            if (ServerConstants.LIVE_CHAT_MEDIA_TYPE_IMAGE == data.mediaType) {
                binding?.ivPhotoToBeSent?.let { ivPhotoToBeSent ->
                    ImageUtils.loadImage(context, uploadedUrl, ivPhotoToBeSent)
                }
                setMediaVisibility(
                    photoVisibility = VISIBLE,
                    videoVisibility = GONE,
                    fileVisibility = GONE,
                    retryVisibility = GONE
                )
            } else if (ServerConstants.LIVE_CHAT_MEDIA_TYPE_VIDEO == data.mediaType) {
                binding?.videoToBeSent?.setData(
                    iVideoItem = IVideoItem(
                        title = null,
                        description = null,
                        fileSize = null,
                        url = uploadedUrl,
                        hideDetails = true,
                        hideSideSpaces = true,
                        date = null,
                        isBotItem = false,
                        isHistoryItem = false
                    ), onItemClickListener = onClickListener
                )
                setMediaVisibility(
                    photoVisibility = GONE,
                    videoVisibility = VISIBLE,
                    fileVisibility = GONE,
                    retryVisibility = GONE
                )
            } else if (ServerConstants.LIVE_CHAT_MEDIA_TYPE_FILE == data.mediaType) {
                binding?.fileView?.setData(
                    iFileItem = IFileItem(
                        fileUrl = uploadedUrl,
                        fileSize = null,
                        fileSizeString = data.mediaSize,
                        fileName = data.mediaName ?: "",
                        hideSideSpaces = true,
                        date = null,
                        isBotItem = false,
                        isHistoryItem = false
                    ),
                    themeColor = themeColor,
                    itemClickListener = onClickListener
                )
                setMediaVisibility(
                    photoVisibility = GONE,
                    videoVisibility = GONE,
                    fileVisibility = VISIBLE,
                    retryVisibility = GONE
                )
            } else {
                setMediaVisibility(
                    photoVisibility = GONE,
                    videoVisibility = GONE,
                    fileVisibility = GONE,
                    retryVisibility = GONE
                )
            }
        } ?: kotlin.run {
            data?.retryData?.let {
                binding?.vRetry?.setData(
                    errorMessage = when (it.failureReason) {
                        ILiveChatMediaUploadFailure.NETWORK_FAILURE -> resources.getString(
                            R.string.upload_failed_due_to_internet_connection_error
                        )
                        ILiveChatMediaUploadFailure.SERVER_FAILURE -> resources.getString(
                            R.string.upload_failed_due_to_server_error
                        )
                        else -> resources.getString(R.string.upload_failed)
                    },
                    retryTag = it,
                    onClickListener = onClickListener
                )
                setMediaVisibility(
                    photoVisibility = GONE,
                    videoVisibility = GONE,
                    fileVisibility = GONE,
                    retryVisibility = VISIBLE
                )
            }
        }

        binding?.ibSend?.tag = data
        binding?.ibSend?.setOnClickListener(onClickListener)

        val isLoading = true == data?.isUploading
        binding?.pbLoading?.visibility = if (isLoading) VISIBLE else GONE
        binding?.vMediaToBeSentContainer?.visibility = if (isLoading) GONE else VISIBLE
        setTextBoxVisibility(visibility = if (!isLoading && data?.retryData == null) VISIBLE else GONE)

        binding?.ibSend?.visibility = if (true == data?.isSendingMessage) GONE else VISIBLE
        binding?.pbSending?.visibility = if (true == data?.isSendingMessage) VISIBLE else GONE

        if (true == data?.clearMessage) {
            binding?.etMessage?.setText("")
        }

        this.visibility = if (true == data?.showPreview) VISIBLE else GONE
    }

    private fun setMediaVisibility(
        photoVisibility: Int,
        videoVisibility: Int,
        fileVisibility: Int,
        retryVisibility: Int
    ) {
        binding?.ivPhotoToBeSent?.visibility = photoVisibility
        binding?.videoToBeSent?.visibility = videoVisibility
        binding?.fileView?.visibility = fileVisibility
        binding?.vRetry?.visibility = retryVisibility
    }

    private fun setTextBoxVisibility(visibility: Int) {
        binding?.etMessage?.visibility = visibility
        binding?.ibSendContainer?.visibility = visibility
        binding?.messageUnderline?.visibility = visibility
    }

    fun getMessage(): String? {
        return binding?.etMessage?.text?.toString()?.ifBlank { null }
    }
}