package ai.engagely.openbot.model.network

object ApiConstants {
    const val COMPANY_URL ="https://www.engagely.ai"
    const val BASE_URL = "https://botbuilder.engagely.ai:8080"
    const val API_REQUEST_TIMEOUT_SECONDS: Long = 60

    const val SOCKET_URL = BASE_URL
    const val LIVE_CHAT_SOCKET_URL = BASE_URL
    const val LIVE_CHAT_SOCKET_PATH = "/livechat_backend_sock/socket.io"
    const val SOCKET_TIMEOUT = 30000L //30 seconds
    const val CHANNEL_CHAT = "chat"
    const val CHANNEL_QUICK_JOURNEY = "quick_journey"
    const val CHANNEL_FLOW = "flow"
    const val CHANNEL_FAQ_CHAT = "faqchat"
    const val CHANNEL_TAB_INFO = "tab_info"
    const val CHANNEL_AGENT_CONNECT_REQUEST = "agent_connect_request"
    const val CHANNEL_USER_REPLY = "user_reply"
    const val CHANNEL_LIVECHAT_USER = "livechat_user"
    const val CHANNEL_USER_END_CHAT = "user_endchat"
    const val CHANNEL_JOIN_ME_HERE = "join_me_here"
    const val CHANNEL_LIVE_USER_DISCONNECT_STATUS = "liveuser_disconnect_status"
    const val CHANNEL_LIVE_TERMINATE_SESSION = "terminate_session"

    const val REQUEST_CHANNEL = "bot"

    const val QUICK_MENU_ITEM_IMAGE_BASE_URL = "$BASE_URL/dmp_backend/"
    const val WELCOME_ITEM_IMAGE_BASE_URL = "$BASE_URL/dmp_backend/"
    const val WELCOME_ITEM_VIDEO_BASE_URL = "$BASE_URL/dmp_backend/"
    const val GREETING_IMAGE_BASE_URL = "$BASE_URL/dmp_backend/"
    const val JOURNEY_DIALOG_IMAGE_BASE_URL = "$BASE_URL/dmp_backend/"
    const val JOURNEY_DIALOG_FILE_BASE_URL = "$BASE_URL/dmp_backend/"
    const val JOURNEY_DIALOG_VIDEO_FILE_BASE_URL = "$BASE_URL/dmp_backend/"
    const val JOURNEY_DIALOG_UPLOADED_FILE_BASE_URL = "$BASE_URL/dmp_backend/"
    const val FAQ_IMAGE_BASE_URL = "$BASE_URL/dmp_backend/"
    const val FAQ_VIDEO_BASE_URL = "$BASE_URL/dmp_backend/"
    const val FAQ_FILE_BASE_URL = "$BASE_URL/dmp_backend/"
    const val TABULAR_DIALOGUE_IMAGE_BASE_URL = "$BASE_URL/dmp_backend/"
    const val TABULAR_DIALOGUE_VIDEO_BASE_URL = "$BASE_URL/dmp_backend/"
    const val TABULAR_DIALOGUE_FILE_BASE_URL = "$BASE_URL/dmp_backend/"
    const val BOT_FEEDBACK_RESPONSE_IMAGE_BASE_URL = "$BASE_URL/dmp_backend/"

    const val YOUTUBE_BANNER_VIDEO_ID_SUBSTITUTE = "<Video_ID>"
    const val YOUTUBE_BANNER_URL =
        "https://img.youtube.com/vi/${YOUTUBE_BANNER_VIDEO_ID_SUBSTITUTE}/0.jpg"

    const val LANGUAGE_SPECIFIC_RESPONSE_KEY_PREFIX = "response_in_"
    const val VIDEO_NAME_KEY = "name"

    const val CHAT_QUERY_TYPE_BUTTON = "button"
    const val CHAT_QUERY_TYPE_TEXT = "text"
    const val CHAT_QUERY_TYPE_VOICE = "voice"
    const val CHAT_EXPECTED_RESPONSE_TYPE_TEXT = "text"
    const val CHAT_EXPECTED_RESPONSE_TYPE_MEDIA = "media"

    const val SESSION_OBJ_USER_ID = "user_id"
}