package ai.engagely.openbot.model.network.interfaces

import ai.engagely.openbot.model.network.ApiConstants
import ai.engagely.openbot.model.pojos.external.apirequests.botsettings.GetBotSettingsRequest
import ai.engagely.openbot.model.pojos.external.apiresponses.botsettings.GetBotSettingsResponse
import retrofit2.Response
import retrofit2.http.Body
import retrofit2.http.POST

interface BotSettingsApi {
    companion object {
        private const val BASE_URL = ApiConstants.BASE_URL
        const val GET_BOT_SETTINGS = "$BASE_URL/chatbot_backend/getbotsettings"
    }

    @POST(GET_BOT_SETTINGS)
    suspend fun getBotSettings(@Body request: GetBotSettingsRequest): Response<GetBotSettingsResponse>
}