package ai.engagely.openbot.model.pojos.internal.chat

import com.google.gson.internal.LinkedTreeMap
import java.util.*

class ITabularValueItem(
    var values: LinkedTreeMap<String, String>,
    val latitude: Double?,
    val longitude: Double?,
    val responseId: String?,
    date: Date?
) : IChatItem(date = date) {

    fun isMapDataAvailable(): Boolean = latitude != null && longitude != null

    override fun makeACopy(): IChatItem {
        return ITabularValueItem(
            values = values,
            latitude = latitude,
            longitude = longitude,
            responseId = responseId,
            date = date
        )
    }
}