package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewQuickMenuListBinding
import ai.engagely.openbot.model.pojos.internal.botsettings.IQuickMenuItem
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class QuickMenuListView : FrameLayout {

    private var binding: ViewQuickMenuListBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewQuickMenuListBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(quickMenuList: List<IQuickMenuItem>, itemClickListener: OnClickListener) {
        binding?.llQuickMenu?.removeAllViews()
        quickMenuList.forEachIndexed { index, iQuickMenuItem ->
            if (!iQuickMenuItem.journeyImageName.isNullOrBlank() && !iQuickMenuItem.topic.isNullOrBlank()) {

                if (index > 0) {
                    binding?.llQuickMenu?.addView(HorizontalDividerView(context))
                }

                val quickMenuListItemView = QuickMenuListItemView(context)
                quickMenuListItemView.setData(iQuickMenuItem.journeyImageUrl, iQuickMenuItem.topic)
                quickMenuListItemView.tag = iQuickMenuItem
                quickMenuListItemView.setOnClickListener(itemClickListener)
                binding?.llQuickMenu?.addView(quickMenuListItemView)
            }
        }
    }
}