package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewTabularSpinnerBinding
import ai.engagely.openbot.model.pojos.internal.chat.ITabularInfoChildItem
import ai.engagely.openbot.model.pojos.internal.chat.ITabularInfoItem
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.widget.AdapterView
import android.widget.ArrayAdapter
import android.widget.FrameLayout

class TabularSpinnerView : FrameLayout {

    private var binding: ViewTabularSpinnerBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewTabularSpinnerBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(
        tabularInfoItem: ITabularInfoItem,
        iTabularInfoChildItem: ITabularInfoChildItem?,
        onClickListener: OnClickListener
    ) {
        binding?.tvLabel?.text = iTabularInfoChildItem?.heading

        iTabularInfoChildItem?.items?.let {
            val adapter = ArrayAdapter(context, R.layout.view_spinner_selected_item, it)
            adapter.setDropDownViewResource(R.layout.view_spinner_dopdown_item)
            binding?.spinner?.adapter = adapter
            binding?.spinner?.setSelection(iTabularInfoChildItem.selectedPosition, false)
            binding?.spinner?.onItemSelectedListener = object : AdapterView.OnItemSelectedListener {
                override fun onItemSelected(
                    adapter: AdapterView<*>?,
                    parent: View?,
                    position: Int,
                    id: Long
                ) {
                    iTabularInfoChildItem.selectedPosition = position

                    val selectedItem = iTabularInfoChildItem.items?.get(position)

                    parent?.tag = selectedItem
                    parent?.setTag(R.id.tabular_item, tabularInfoItem)
                    parent?.setTag(R.id.tabular_item_child, iTabularInfoChildItem)

                    onClickListener.onClick(parent)
                }

                override fun onNothingSelected(adapter: AdapterView<*>?) {
                    //Nothing to do
                }
            }
        }

        binding?.progressBar?.visibility = if (iTabularInfoChildItem?.isLoading == true) {
            VISIBLE
        } else {
            GONE
        }
    }
}