package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewTabularValueItemBinding
import android.content.Context
import android.graphics.Typeface
import android.text.Spannable
import android.text.SpannableString
import android.text.style.StyleSpan
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class TabularValueItemView : FrameLayout {

    private var binding: ViewTabularValueItemBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewTabularValueItemBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(key: String, value: String, color: Int) {

        binding?.tvValue?.setTextColor(color)
        val spannable = SpannableString("$key: $value")
        spannable.setSpan(
            StyleSpan(Typeface.BOLD),
            0,
            key.length + 1,
            Spannable.SPAN_EXCLUSIVE_EXCLUSIVE
        )
        binding?.tvValue?.text = spannable
    }
}