package ai.engagely.openbot.model.network

import ai.engagely.openbot.viewmodel.VideoPlayerViewModel
import android.content.Context
import com.google.android.exoplayer2.database.StandaloneDatabaseProvider
import com.google.android.exoplayer2.upstream.cache.LeastRecentlyUsedCacheEvictor
import com.google.android.exoplayer2.upstream.cache.SimpleCache

class VideoCache(private val simpleCache: SimpleCache) {

    fun getSimpleCache() = simpleCache

    companion object {

        @Volatile
        private var INSTANCE: VideoCache? = null

        fun getInstance(context: Context): VideoCache = INSTANCE ?: synchronized(this) {
            INSTANCE ?: createSimpleVideoCache(context).also { INSTANCE = it }
        }

        private fun createSimpleVideoCache(context: Context): VideoCache {
            return VideoCache(
                SimpleCache(
                    context.cacheDir,
                    LeastRecentlyUsedCacheEvictor(VideoPlayerViewModel.CACHE_SIZE),
                    StandaloneDatabaseProvider(context)
                )
            )
        }
    }
}