package ai.engagely.openbot.model.network.interfaces

import ai.engagely.openbot.model.network.ApiConstants
import ai.engagely.openbot.model.pojos.external.apirequests.botfeedback.GiveCsatRequest
import ai.engagely.openbot.model.pojos.external.apirequests.botfeedback.SetBotFeedbackRequest
import ai.engagely.openbot.model.pojos.external.apiresponses.botfeedback.GiveCsatResponse
import ai.engagely.openbot.model.pojos.external.apiresponses.botfeedback.SetBotFeedbackResponse
import retrofit2.Response
import retrofit2.http.Body
import retrofit2.http.POST

interface BotFeedbackApi {
    companion object {
        private const val BASE_URL = ApiConstants.BASE_URL
        const val SET_FEEDBACK = "$BASE_URL/chatbot_backend/set_feedback"
        const val GIVE_CSAT = "$BASE_URL/chatbot_backend/give_csat"
    }

    @POST(SET_FEEDBACK)
    suspend fun setBotFeedback(@Body request: SetBotFeedbackRequest): Response<SetBotFeedbackResponse>

    @POST(GIVE_CSAT)
    suspend fun giveCsat(@Body request: GiveCsatRequest): Response<GiveCsatResponse>
}