package ai.engagely.openbot.model.pojos.internal.chat

import ai.engagely.openbot.model.pojos.internal.history.ICarousalDataContainer
import java.util.*

class IDialogueCarousalItem(
    val carousalDataContainer: ICarousalDataContainer,
    date: Date?,
    isBotItem: Boolean,
    isHistoryItem: Boolean,
    uuid: String = UUID.randomUUID().toString(),
    pendingData: Any? = null
) : IChatItem(
    date = date,
    isBotItem = isBotItem,
    isHistoryItem = isHistoryItem,
    uuid = uuid,
    pendingData = pendingData
) {
    override fun makeACopy(): IChatItem {
        return IDialogueCarousalItem(
            carousalDataContainer = carousalDataContainer,
            date = date,
            isBotItem = isBotItem,
            isHistoryItem = isHistoryItem,
            uuid = uuid,
            pendingData = pendingData
        )
    }
}