package ai.engagely.openbot.model.pojos.internal.chat

import java.util.*

class IFileItem(
    val fileUrl: String,
    val fileSize: Long?,
    val fileSizeString: String? = null,
    val fileName: String,
    val fileText: String? = null,
    val hideSideSpaces: Boolean = false,
    date: Date?,
    isBotItem: Boolean,
    isHistoryItem: Boolean,
    uuid: String = UUID.randomUUID().toString(),
    pendingData: Any? = null
) : IChatItem(
    date = date,
    isBotItem = isBotItem,
    isHistoryItem = isHistoryItem,
    uuid = uuid,
    pendingData = pendingData
) {
    override fun makeACopy(): IChatItem {
        return IFileItem(
            fileUrl = fileUrl,
            fileSize = fileSize,
            fileSizeString = fileSizeString,
            fileName = fileName,
            fileText = fileText,
            hideSideSpaces = hideSideSpaces,
            date = date,
            isBotItem = isBotItem,
            isHistoryItem = isHistoryItem,
            uuid = uuid,
            pendingData = pendingData
        )
    }
}