package ai.engagely.openbot.model.pojos.internal.chat

import java.util.*

class IImageItem(
    val imageUrl: String?,
    val hideDate: Boolean = false,
    date: Date? = null,
    isLoading: Boolean = false,
    isBotItem: Boolean = false,
    isHistoryItem: Boolean = false,
    uuid: String = UUID.randomUUID().toString(),
    pendingData: Any? = null
) : IChatItem(date, isLoading, isBotItem, isHistoryItem, uuid, pendingData) {
    override fun makeACopy(): IChatItem {
        return IImageItem(
            imageUrl = imageUrl,
            date = date,
            isLoading = isLoading,
            isBotItem = isBotItem,
            isHistoryItem = isHistoryItem,
            hideDate = hideDate,
            uuid = uuid,
            pendingData = pendingData
        )
    }
}