package ai.engagely.openbot.model.pojos.internal.chat

import java.util.*

class IMessageItem(
    val message: String,
    val isHtml: Boolean = false,
    val isVoiceMessage: Boolean = false,
    var isVoicePlaying: Boolean = false,
    var hideTime: Boolean = false,
    date: Date? = null,
    isLoading: Boolean = false,
    isBotItem: Boolean = false,
    isHistoryItem: Boolean = false,
    uuid: String = UUID.randomUUID().toString(),
    pendingData: Any? = null
) : IChatItem(date, isLoading, isBotItem, isHistoryItem, uuid, pendingData) {
    override fun makeACopy(): IChatItem {
        return IMessageItem(
            message = message,
            isHtml = isHtml,
            isVoiceMessage = isVoiceMessage,
            isVoicePlaying = isVoicePlaying,
            hideTime = hideTime,
            date = date,
            isLoading = isLoading,
            isBotItem = isBotItem,
            isHistoryItem = isHistoryItem,
            uuid = uuid,
            pendingData = pendingData
        )
    }
}
