package ai.engagely.openbot.model.pojos.internal.chat

import java.util.*

class ITabularValueItem(
    var values: SortedMap<String, String>,
    val latitude: Double?,
    val longitude: Double?,
    val responseId: String?,
    uuid: String = UUID.randomUUID().toString(),
    date: Date?
) : IChatItem(date = date, uuid = uuid) {

    fun isMapDataAvailable(): Boolean = latitude != null && longitude != null

    override fun makeACopy(): IChatItem {
        return ITabularValueItem(
            values = values,
            latitude = latitude,
            longitude = longitude,
            responseId = responseId,
            date = date
        )
    }
}