package ai.engagely.openbot.model.repositories.impl

import ai.engagely.openbot.model.network.ApiClient
import ai.engagely.openbot.model.network.interfaces.BotFeedbackApi
import ai.engagely.openbot.model.pojos.external.apirequests.botfeedback.GiveCsatRequest
import ai.engagely.openbot.model.pojos.external.apirequests.botfeedback.SetBotFeedbackRequest
import ai.engagely.openbot.model.repositories.BotFeedbackRepository
import ai.engagely.openbot.model.utils.general.LogUtils
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.withContext
import java.net.HttpURLConnection

class AppBotFeedbackRepository(private val dispatcher: CoroutineDispatcher) :
    BotFeedbackRepository {
    override suspend fun setFeedback(intId: String?, sessionId: String?): Boolean {
        return withContext(dispatcher) {
            try {
                val botFeedbackApi =
                    ApiClient.getInstance().getClient().create(BotFeedbackApi::class.java)
                val setBotFeedbackRequest =
                    SetBotFeedbackRequest(feedback = true, intId = intId, sessionId = sessionId)
                val response = botFeedbackApi.setBotFeedback(setBotFeedbackRequest)
                if (response.isSuccessful && response.code() == HttpURLConnection.HTTP_OK && response.body()?.success == true) {
                    return@withContext true
                }
            } catch (e: Exception) {
                LogUtils.logException(e)
            }
            return@withContext false
        }
    }

    override suspend fun giveCsat(
        intId: String?,
        sessionId: String?,
        socketId: String?,
        stars: Int
    ): Boolean {
        return withContext(dispatcher) {
            try {
                val botFeedbackApi =
                    ApiClient.getInstance().getClient().create(BotFeedbackApi::class.java)
                val giveCsatRequest =
                    GiveCsatRequest(
                        intId = intId,
                        sessionId = sessionId,
                        socketid = socketId,
                        stars = stars
                    )
                val response = botFeedbackApi.giveCsat(giveCsatRequest)
                if (response.isSuccessful && response.code() == HttpURLConnection.HTTP_OK && response.body()?.success == true) {
                    return@withContext true
                }
            } catch (e: Exception) {
                LogUtils.logException(e)
            }
            return@withContext false
        }
    }
}