package ai.engagely.openbot.model.repositories.impl

import ai.engagely.openbot.model.network.ApiClient
import ai.engagely.openbot.model.network.interfaces.AutoCompleteFaqApi
import ai.engagely.openbot.model.pojos.external.apirequests.faqautocomplete.AutoCompleteFaqRequest
import ai.engagely.openbot.model.pojos.internal.faqautocomplete.IFaqAutoCompleteItem
import ai.engagely.openbot.model.repositories.FaqAutoCompleteRepository
import ai.engagely.openbot.model.utils.general.LogUtils
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.withContext

class AppFaqAutoCompleteRepository(
    private val dispatcher: CoroutineDispatcher,
) : FaqAutoCompleteRepository {

    override suspend fun autoComplete(
        text: String,
        intId: String?,
        sessionId: String?
    ): List<IFaqAutoCompleteItem>? {
        return withContext(dispatcher) {
            try {
                val autoCompleteApi =
                    ApiClient.getInstance().getClient().create(AutoCompleteFaqApi::class.java)

                val autoCompleteRequest =
                    AutoCompleteFaqRequest(userInput = text, intId = intId, sessionId = sessionId)

                val response = autoCompleteApi.autoCompleteFaq(autoCompleteRequest)
                if (response.isSuccessful && response.body()?.success == true) {
                    val faqItems = ArrayList<IFaqAutoCompleteItem>()
                    response.body()?.data?.forEach { data ->
                        faqItems.add(
                            IFaqAutoCompleteItem(
                                faqId = data.fAQID,
                                journeyId = data.journeyID,
                                journeyName = data.journeyName,
                                question = data.question
                            )
                        )
                    }
                    return@withContext faqItems.ifEmpty { null }
                }
            } catch (e: Exception) {
                LogUtils.logException(e)
            }
            return@withContext null
        }
    }
}