package ai.engagely.openbot.model.utils.converters

import ai.engagely.openbot.model.pojos.internal.botsettings.IBotChatWindowConfig
import ai.engagely.openbot.model.pojos.internal.chat.*
import java.util.*

class BotConfigConverter {

    fun convertToInitialGreetingItems(iBotChatWindowConfig: IBotChatWindowConfig?): List<IChatItem> {
        val chatItems = ArrayList<IChatItem>()
        when {
            iBotChatWindowConfig?.greetingMessage != null -> {
                chatItems.addAll(iBotChatWindowConfig.greetingMessage.messages.map {
                    IMessageItem(
                        message = it.message,
                        date = it.date,
                        isLoading = false,
                        isBotItem = true,
                        isHtml = true
                    )
                })
            }
            iBotChatWindowConfig?.carousalGreetingMessage != null -> {
                chatItems.add(
                    ICarousalImageItem(
                        header = iBotChatWindowConfig.carousalGreetingMessage.headerMessage,
                        messages = iBotChatWindowConfig.carousalGreetingMessage.messages.map { iGreetingMessageItem -> iGreetingMessageItem.message },
                        images = iBotChatWindowConfig.carousalGreetingMessage.greetingCarousalImages
                            ?: emptyList(),
                        textColor = iBotChatWindowConfig.carousalGreetingMessage.color,
                        date = Date(),
                        isLoading = false,
                        isBotItem = true
                    )
                )
            }
        }
        createTopJourneyItemForChat(iBotChatWindowConfig)?.let {
            chatItems.add(it)
        }
        return chatItems
    }

    fun convertToPostChatGreetingItems(iBotChatWindowConfig: IBotChatWindowConfig?): List<IChatItem>? {
        return iBotChatWindowConfig?.greetingMessageWithHeader?.messages?.map { greetingMessageItem ->
            IMessageItem(
                message = greetingMessageItem.message,
                date = greetingMessageItem.date,
                isLoading = false,
                isBotItem = true,
                isHtml = true
            )
        }
    }

    private fun createTopJourneyItemForChat(iBotChatWindowConfig: IBotChatWindowConfig?): IMultipleOptionsItem? {
        iBotChatWindowConfig?.topJrItems?.filter {
            it.newTopic?.isNotBlank() == true
        }?.map {
            IChatItemOption(
                name = it.newTopic ?: "",
                isNew = it.newTag ?: false,
                optionObject = it
            )
        }?.let {
            if (it.isNotEmpty()) {
                return IMultipleOptionsItem(
                    options = it,
                    optionsStyle = iBotChatWindowConfig.optionsStyle,
                    optionsHeader = iBotChatWindowConfig.topJourneyHeader,
                    date = Date(),
                    isLoading = false,
                    isBotItem = true,
                )
            }
        }
        return null
    }
}