package ai.engagely.openbot.model.utils.exts

import android.util.Patterns

fun String?.obtainNonBlankOrNull(): String? {
    if (this?.isNotBlank() == true) {
        return this
    }
    return null
}

fun CharSequence?.isValidEmail() =
    !isNullOrEmpty() && Patterns.EMAIL_ADDRESS.matcher(this).matches()