package ai.engagely.openbot.model.utils.exts

import ai.engagely.openbot.model.utils.general.ToastUtils
import android.app.Activity
import android.content.Context
import android.graphics.BlendMode
import android.graphics.BlendModeColorFilter
import android.graphics.Insets
import android.graphics.PorterDuff
import android.graphics.drawable.Drawable
import android.graphics.drawable.GradientDrawable
import android.os.Build
import android.util.DisplayMetrics
import android.view.View
import android.view.WindowInsets
import android.view.inputmethod.InputMethodManager
import android.widget.EditText
import androidx.annotation.ColorInt
import androidx.lifecycle.AndroidViewModel
import androidx.lifecycle.viewModelScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch


fun Drawable.overrideWithCustomColor(@ColorInt colorInt: Int) {
    if (Build.VERSION.SDK_INT > Build.VERSION_CODES.Q) {
        this.colorFilter = BlendModeColorFilter(colorInt, BlendMode.SRC_ATOP)
    } else {
        this.setColorFilter(colorInt, PorterDuff.Mode.SRC_ATOP)
    }
}

fun Activity.hideKeyboard() {
    this.window?.currentFocus?.let {
        it.clearFocus()
        (this.getSystemService(Context.INPUT_METHOD_SERVICE) as InputMethodManager)
            .hideSoftInputFromWindow(it.windowToken, 0)
    }
}

fun EditText.consumeText(): String {
    val typedText = this.text.toString()
    this.setText("")
    return typedText
}

fun View?.setBorderBg(color: Int, borderSize: Int, cornerRadius: Float) {
    this?.let {
        val gd = GradientDrawable()
        gd.setColor(0x00000000)
        gd.cornerRadius = cornerRadius
        gd.setStroke(borderSize, color)
        it.background = gd
    }
}

fun View?.setCustomRoundedBg(color: Int, cornerRadius: Float) {
    this?.let {
        val gd = GradientDrawable()
        gd.setColor(color)
        gd.cornerRadius = cornerRadius
        it.background = gd
    }
}

fun AndroidViewModel.showToast(message: String) {
    this.viewModelScope.launch(Dispatchers.Main) {
        ToastUtils.showToast(message, this@showToast.getApplication())
    }
}

fun Activity.showToast(message: String) {
    ToastUtils.showToast(message, this)
}

fun Activity.getScreenWidth(): Int {
    return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R) {
        val windowMetrics = this.windowManager.currentWindowMetrics
        val insets: Insets = windowMetrics.windowInsets
            .getInsetsIgnoringVisibility(WindowInsets.Type.systemBars())
        windowMetrics.bounds.width() - insets.left - insets.right
    } else {
        val displayMetrics = DisplayMetrics()
        this.windowManager.defaultDisplay.getMetrics(displayMetrics)
        displayMetrics.widthPixels
    }
}

fun Activity.getScreenHeight(): Int {
    return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R) {
        val windowMetrics = this.windowManager.currentWindowMetrics
        val insets: Insets = windowMetrics.windowInsets
            .getInsetsIgnoringVisibility(WindowInsets.Type.systemBars())
        windowMetrics.bounds.height() - insets.bottom - insets.top
    } else {
        val displayMetrics = DisplayMetrics()
        this.windowManager.defaultDisplay.getMetrics(displayMetrics)
        displayMetrics.heightPixels
    }
}
