package ai.engagely.openbot.model.utils.general

import okhttp3.MediaType.Companion.toMediaTypeOrNull
import okhttp3.MultipartBody
import okhttp3.RequestBody
import okhttp3.RequestBody.Companion.asRequestBody
import okhttp3.RequestBody.Companion.toRequestBody
import java.io.File


object RetrofitUtils {

    fun createPartFromString(descriptionString: String): RequestBody {
        return descriptionString
            .toRequestBody(MultipartBody.FORM)
    }

    fun prepareFilePart(
        partName: String,
        file: File,
        mimeType: String
    ): MultipartBody.Part {

        // create RequestBody instance from file
        val requestFile = file.asRequestBody(mimeType.toMediaTypeOrNull())

        // MultipartBody.Part is used to send also the actual file name
        return MultipartBody.Part.createFormData(partName, file.name, requestFile)
    }
}