package ai.engagely.openbot.view.adapters

import ai.engagely.openbot.model.pojos.internal.history.ICarousalData
import ai.engagely.openbot.view.customviews.DialogueCarousalItemView
import android.view.View
import android.view.ViewGroup
import androidx.viewpager.widget.PagerAdapter

class DialogueCarousalImageAdapter(
    private val carousalImageItems: List<ICarousalData>,
    private val itemImageHeight: Int,
    private val itemClickListener: View.OnClickListener
) : PagerAdapter() {
    override fun getCount(): Int {
        return carousalImageItems.size
    }

    override fun instantiateItem(container: ViewGroup, position: Int): Any {
        val view = DialogueCarousalItemView(container.context)
        view.setData(carousalImageItems[position], itemImageHeight, itemClickListener)
        container.addView(view)
        return view
    }

    override fun isViewFromObject(view: View, `object`: Any): Boolean {
        return view == `object`
    }

    override fun destroyItem(container: ViewGroup, position: Int, `object`: Any) {
        container.removeView(`object` as DialogueCarousalItemView)
    }
}