package ai.engagely.openbot.view.adapters

import ai.engagely.openbot.model.pojos.internal.botsettings.IGreetingCarousalImage
import ai.engagely.openbot.view.customviews.GreetingImageCarousalItemView
import android.view.View
import android.view.ViewGroup
import androidx.viewpager.widget.PagerAdapter

class GreetingImageCarousalAdapter(
    private val images: List<IGreetingCarousalImage>,
    private val imageClickListener: View.OnClickListener
) :
    PagerAdapter() {
    override fun getCount(): Int {
        return images.size
    }

    override fun instantiateItem(container: ViewGroup, position: Int): Any {
        val view = GreetingImageCarousalItemView(container.context)
        view.setData(images[position], imageClickListener)
        container.addView(view)
        return view
    }

    override fun isViewFromObject(view: View, `object`: Any): Boolean {
        return view == `object`
    }

    override fun destroyItem(container: ViewGroup, position: Int, `object`: Any) {
        container.removeView(`object` as GreetingImageCarousalItemView)
    }
}