package ai.engagely.openbot.view.adapters.viewholders

import ai.engagely.openbot.model.pojos.internal.chat.ITabularValueItem
import ai.engagely.openbot.view.customviews.TabularValueWithMapView
import androidx.recyclerview.widget.RecyclerView
import com.google.android.gms.maps.GoogleMap
import com.google.android.gms.maps.MapsInitializer
import com.google.android.gms.maps.OnMapReadyCallback
import com.google.android.gms.maps.model.LatLng
import com.google.android.gms.maps.model.MarkerOptions

class TabularValueWithMapHolder(private val view: TabularValueWithMapView) :
    RecyclerView.ViewHolder(view), OnMapReadyCallback {

    private lateinit var map: GoogleMap
    private lateinit var latLng: LatLng

    init {
        view.getMapView()?.run {
            // Initialise the MapView
            onCreate(null)
            // Set the map ready callback to receive the GoogleMap object
            getMapAsync(this@TabularValueWithMapHolder)
        }
    }

    fun setData(tabularValueItem: ITabularValueItem?, textColor: Int, bgColor: Int) {
        view.setData(tabularValueItem, textColor, bgColor)

        if (tabularValueItem?.latitude != null && tabularValueItem.longitude != null) {
            latLng = LatLng(tabularValueItem.latitude, tabularValueItem.longitude)
            setMapLocation()
        }
    }

    override fun onMapReady(googleMap: GoogleMap) {
        MapsInitializer.initialize(view.context)
        // If map is not initialised properly
        map = googleMap ?: return
        setMapLocation()
    }

    private fun setMapLocation() {
        if (!::map.isInitialized) return
        if (!::latLng.isInitialized) return
        with(map) {
            moveCamera(com.google.android.gms.maps.CameraUpdateFactory.newLatLngZoom(latLng, 13f))
            addMarker(MarkerOptions().position(latLng))
            mapType = com.google.android.gms.maps.GoogleMap.MAP_TYPE_NORMAL
            setOnMapClickListener {

            }
        }
    }

    fun clearView() {
        if (!::map.isInitialized) return
        with(map) {
            // Clear the map and free up resources by changing the map type to none
            clear()
            mapType = com.google.android.gms.maps.GoogleMap.MAP_TYPE_NONE
        }
    }
}