package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewBotContainerBinding
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout
import android.widget.ScrollView

class BotContainerView : FrameLayout {

    private var binding: ViewBotContainerBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewBotContainerBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun getBotView(): BotView? {
        return binding?.botView
    }

    fun getWelcomeData(): WelcomeDataView? {
        return binding?.vWelcomeData
    }

    fun getWelcomeDataContainer(): ScrollView? {
        return binding?.svWelcomeData
    }
}