package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewBotFeedbackBinding
import ai.engagely.openbot.model.pojos.internal.botsettings.IBotFeedbackRequest
import ai.engagely.openbot.model.pojos.internal.common.IBotFeedbackNegativeClick
import ai.engagely.openbot.model.pojos.internal.common.IBotFeedbackPositiveClick
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class BotFeedbackView : FrameLayout {

    private var binding: ViewBotFeedbackBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewBotFeedbackBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setColor(color: Int) {
        binding?.ivThumbsUp?.setColorFilter(color)
        binding?.ivThumbsUpFilled?.setColorFilter(color)
        binding?.ivThumbsDown?.setColorFilter(color)
        binding?.ivThumbsDownFilled?.setColorFilter(color)
    }

    fun setData(data: IBotFeedbackRequest?, onClickListener: OnClickListener) {
        data?.let { iBotFeedbackRequest ->
            binding?.ivThumbsUp?.isClickable = false
            binding?.ivThumbsDown?.isClickable = false
            when (iBotFeedbackRequest.iBotFeedbackSubmitStatus) {
                IBotFeedbackRequest.IBotFeedbackSubmitStatus.NOT_SUBMITTED -> {
                    setThumbsVisibility(thumbsUpShown = false, thumbsDownShows = false)
                    binding?.ivThumbsUp?.isClickable = true
                    binding?.ivThumbsUp?.tag =
                        IBotFeedbackPositiveClick(iBotFeedbackRequest = iBotFeedbackRequest)
                    binding?.ivThumbsUp?.setOnClickListener(onClickListener)

                    binding?.ivThumbsDown?.isClickable = true
                    binding?.ivThumbsDown?.tag =
                        IBotFeedbackNegativeClick(iBotFeedbackRequest = iBotFeedbackRequest)
                    binding?.ivThumbsDown?.setOnClickListener(onClickListener)
                }
                IBotFeedbackRequest.IBotFeedbackSubmitStatus.SUBMITTED_POSITIVE -> {
                    setThumbsVisibility(thumbsUpShown = true, thumbsDownShows = false)
                }
                IBotFeedbackRequest.IBotFeedbackSubmitStatus.SUBMITTED_NEGATIVE -> {
                    setThumbsVisibility(thumbsUpShown = false, thumbsDownShows = true)
                }
            }
            visibility = VISIBLE
        } ?: kotlin.run {
            visibility = GONE
        }
    }

    private fun setThumbsVisibility(thumbsUpShown: Boolean, thumbsDownShows: Boolean) {
        binding?.ivThumbsUp?.visibility = if (thumbsUpShown) GONE else VISIBLE
        binding?.ivThumbsUpFilled?.visibility = if (thumbsUpShown) VISIBLE else GONE
        binding?.ivThumbsDown?.visibility = if (thumbsDownShows) GONE else VISIBLE
        binding?.ivThumbsDownFilled?.visibility = if (thumbsDownShows) VISIBLE else GONE
    }
}