package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewBottomQuickMenuGridBinding
import ai.engagely.openbot.model.pojos.internal.botsettings.IQuickMenuItem
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class BottomQuickMenuGridView : FrameLayout {

    private var binding: ViewBottomQuickMenuGridBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewBottomQuickMenuGridBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(quickMenuList: List<IQuickMenuItem>, itemClickListener: OnClickListener) {
        binding?.flBottomQuickMenuContainer?.removeAllViews()
        quickMenuList.forEach {
            if (!it.journeyImageName.isNullOrBlank() && !it.topic.isNullOrBlank()) {
                val quickMenuItemView = QuickMenuItemView(context)
                quickMenuItemView.setData(it.journeyImageUrl, it.topic)
                quickMenuItemView.tag = it
                quickMenuItemView.setOnClickListener(itemClickListener)
                binding?.flBottomQuickMenuContainer?.addView(quickMenuItemView)
            }
        }
    }
}