package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewDialogueCarousalButtonBinding
import ai.engagely.openbot.model.pojos.internal.history.ICarousalButtonData
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class DialogueCarousalButtonView : FrameLayout {

    private var binding: ViewDialogueCarousalButtonBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding =
            ViewDialogueCarousalButtonBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(
        iCarousalButtonData: ICarousalButtonData?,
        onItemClickListener: OnClickListener
    ) {
        binding?.btCarousal?.apply {
            text = iCarousalButtonData?.buttonName
            tag = iCarousalButtonData
            setOnClickListener(onItemClickListener)
        }
    }
}