package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewFormButtonBinding
import ai.engagely.openbot.model.pojos.internal.chat.IChatFormItem
import ai.engagely.openbot.model.pojos.internal.history.IFormButtonItem
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class FormButtonView : FrameLayout {

    private var binding: ViewFormButtonBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewFormButtonBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(
        iFormButtonItem: IFormButtonItem,
        iChatFormItem: IChatFormItem,
        themeColor: Int,
        itemClickListener: OnClickListener
    ) {
        binding?.button?.text = iFormButtonItem.labelName
        binding?.button?.setTag(R.id.tag_form_item, iChatFormItem)
        binding?.button?.tag = iFormButtonItem
        binding?.button?.setOnClickListener(itemClickListener)
        binding?.button?.setBackgroundColor(themeColor)

        if (iFormButtonItem.disableAfterClick == true) {
            val enableButton = !iFormButtonItem.isSubmitted
            binding?.button?.isEnabled = enableButton
            binding?.button?.alpha = if (enableButton) 1.0f else 0.6f
        }

        setLoading(iFormButtonItem.isLoading)
    }

    private fun setLoading(loading: Boolean) {
        if (loading) {
            binding?.progressBar?.visibility = VISIBLE
            binding?.button?.visibility = GONE
        } else {
            binding?.button?.visibility = VISIBLE
            binding?.progressBar?.visibility = GONE
        }
    }
}