package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewGreetingImageCarousalItemBinding
import ai.engagely.openbot.model.pojos.internal.botsettings.IGreetingCarousalImage
import ai.engagely.openbot.model.utils.general.ImageUtils
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class GreetingImageCarousalItemView : FrameLayout {

    private var binding: ViewGreetingImageCarousalItemBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding =
            ViewGreetingImageCarousalItemBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(
        iGreetingCarousalImage: IGreetingCarousalImage,
        imageClickListener: OnClickListener
    ) {
        iGreetingCarousalImage.imageName?.let { imageUrl ->
            binding?.ivGreetingImageCarousal?.let { imageView ->
                ImageUtils.loadImage(context, imageUrl, imageView)

                imageView.tag = iGreetingCarousalImage
                imageView.setOnClickListener(imageClickListener)
            }
        }
    }
}