package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewGreetingImageCarousalBinding
import ai.engagely.openbot.model.constants.AppConstants
import ai.engagely.openbot.model.constants.ViewConstants
import ai.engagely.openbot.model.pojos.internal.chat.ICarousalImageItem
import ai.engagely.openbot.model.utils.general.ViewUtils
import ai.engagely.openbot.view.adapters.GreetingImageCarousalAdapter
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.ViewTreeObserver
import android.widget.FrameLayout

class GreetingImageCarousalView : FrameLayout {

    private var binding: ViewGreetingImageCarousalBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewGreetingImageCarousalBinding.inflate(LayoutInflater.from(context), this, true)

        //Adjust pager height based on available width
        binding?.vpImagePagerContainer?.viewTreeObserver?.addOnGlobalLayoutListener(object :
            ViewTreeObserver.OnGlobalLayoutListener {
            override fun onGlobalLayout() {
                ViewUtils.removeGlobalLayoutListener(binding?.vpImagePagerContainer, this)
                val width = binding?.vpImagePagerContainer?.width ?: 0
                if (width > 0) {
                    val height =
                        (width * AppConstants.GREETING_CAROUSAL_IMAGE_HEIGHT_REF) / AppConstants.GREETING_CAROUSAL_IMAGE_WIDTH_REF
                    val welcomeImageLayoutParams = binding?.vpImagePagerContainer?.layoutParams
                    welcomeImageLayoutParams?.height = height.toInt()
                    binding?.vpImagePagerContainer?.layoutParams = welcomeImageLayoutParams
                }
            }
        })
    }

    fun setData(
        iCarousalImageItem: ICarousalImageItem?,
        themeColor: Int,
        imageClickListener: OnClickListener
    ) {
        val adapter = GreetingImageCarousalAdapter(
            iCarousalImageItem?.images ?: ArrayList(),
            imageClickListener
        )
        binding?.vpImagePager?.adapter = adapter

        binding?.vpImagePager?.let { pager ->
            binding?.tlImage?.setupWithViewPager(pager, true);
        }

        val textColor = ViewUtils.parseColorSafely(
            iCarousalImageItem?.textColor, ViewConstants.VIEW_DEFAULT_COLOR_STRING
        )
        binding?.tvHeader?.text = iCarousalImageItem?.header
        binding?.tvHeader?.setTextColor(textColor)
        binding?.llMessagesContainer?.removeAllViews()
        iCarousalImageItem?.messages?.forEach {
            val messageItem = GreetingCarousalMessageItemView(context)
            messageItem.setData(it, textColor)
            binding?.llMessagesContainer?.addView(messageItem)
        }

        binding?.vTopBgStrip?.setBackgroundColor(themeColor)

        binding?.ivNext?.setOnClickListener {
            val vpSize = iCarousalImageItem?.images?.size ?: 0
            var currentPosition = binding?.vpImagePager?.currentItem ?: 0
            if (currentPosition < (vpSize - 1)) {
                binding?.vpImagePager?.setCurrentItem(++currentPosition, true)
            }
        }

        binding?.ivPrev?.setOnClickListener {
            var currentPosition = binding?.vpImagePager?.currentItem ?: 0
            if (currentPosition > 0) {
                binding?.vpImagePager?.setCurrentItem(--currentPosition, true)
            }
        }
    }

}