package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewItemBotMessageBinding
import ai.engagely.openbot.model.pojos.internal.chat.IMessageItem
import ai.engagely.openbot.model.utils.general.LogUtils
import ai.engagely.openbot.view.adapters.ChatItemsRecyclerViewAdapter
import android.content.Context
import android.text.method.LinkMovementMethod
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout
import androidx.core.content.ContextCompat
import androidx.core.text.parseAsHtml

class ItemBotMessageView : FrameLayout {

    private var binding: ViewItemBotMessageBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewItemBotMessageBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(
        messageItem: IMessageItem?,
        bgColor: Int,
        textColor: Int,
        speechListener: ChatItemsRecyclerViewAdapter.SpeechListener?
    ) {
        if (messageItem?.isHtml == true) {
            binding?.tvMessage?.text = try {
                messageItem.message.parseAsHtml().trimEnd()
            } catch (e: Exception) {
                LogUtils.logException(e)
                messageItem.message
            }
            binding?.tvMessage?.movementMethod = LinkMovementMethod.getInstance()
        } else {
            binding?.tvMessage?.text = messageItem?.message
            binding?.tvMessage?.movementMethod = null
        }
        binding?.tvMessage?.setTextColor(textColor)
        binding?.rlMessageContainer?.setCardBackgroundColor(bgColor)
        binding?.tvTime?.setData(messageItem?.date, messageItem?.hideTime)

        if (speechListener != null) {
            binding?.ibSpeaker?.visibility = VISIBLE
            binding?.ibSpeaker?.setColorFilter(
                if (messageItem?.isVoicePlaying == true) ContextCompat.getColor(
                    context,
                    R.color.green
                ) else textColor
            )
            binding?.ibSpeaker?.setOnClickListener {
                messageItem?.message?.let {
                    speechListener.onSpeechRequested(messageItem)
                }
            }
        } else {
            binding?.ibSpeaker?.visibility = GONE
        }
    }
}