package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewCustomFormNoCardBinding
import ai.engagely.openbot.model.pojos.internal.chat.IChatCustomFormItem
import ai.engagely.openbot.model.pojos.internal.common.IChangeLanguageData
import ai.engagely.openbot.model.pojos.internal.common.ISendQuickJourneyData
import ai.engagely.openbot.model.utils.helpers.CustomActionListener
import ai.engagely.openbot.model.utils.helpers.RequestParentTouchForScrollHelper
import ai.engagely.openbot.model.utils.javascriptinterfaces.CustomFormJavascriptInterface
import android.content.Context
import android.util.AttributeSet
import android.util.Base64
import android.view.LayoutInflater
import android.webkit.WebSettings
import android.widget.FrameLayout
import android.widget.LinearLayout

class ItemCustomFormNoCardView : FrameLayout {

    private var binding: ViewCustomFormNoCardBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewCustomFormNoCardBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(
        iChatCustomFormItem: IChatCustomFormItem?,
        customActionListener: CustomActionListener
    ) {

        binding?.llFormContainer?.layoutParams?.let {
            if (it is LinearLayout.LayoutParams) {
                it.weight = iChatCustomFormItem?.widthFraction ?: 1f
            }
        }
        binding?.vEmptyArea?.layoutParams?.let {
            if (it is LinearLayout.LayoutParams) {
                it.weight = 1 - (iChatCustomFormItem?.widthFraction ?: 1f)
            }
        }

        iChatCustomFormItem?.htmlData?.let { htmlData ->
            val encodedHtml = Base64.encodeToString(htmlData.toByteArray(), Base64.NO_PADDING)
            binding?.wvForm?.loadData(encodedHtml, "text/html", "base64")

            binding?.wvForm?.setOnTouchListener(RequestParentTouchForScrollHelper())

            binding?.wvForm?.settings?.apply {
                javaScriptEnabled = true
                domStorageEnabled = true
                loadWithOverviewMode = true
                javaScriptCanOpenWindowsAutomatically = true
                builtInZoomControls = true
                displayZoomControls = false
                setSupportZoom(true)
                setSupportMultipleWindows(true)
                mixedContentMode = WebSettings.MIXED_CONTENT_ALWAYS_ALLOW
            }

            binding?.wvForm?.addJavascriptInterface(CustomFormJavascriptInterface(object :
                CustomFormJavascriptInterface.JavascriptEventListener {
                override fun changeLanguage(newLanguageCode: String) {
                    try {
                        customActionListener.onActionPerformed(IChangeLanguageData(newLanguage = newLanguageCode))
                    } catch (ignore: Exception) {
                    }
                }

                override fun startQuickJourney(journeyName: String, fieldText: String) {
                    try {
                        customActionListener.onActionPerformed(
                            ISendQuickJourneyData(
                                journeyName = journeyName,
                                fieldText = fieldText
                            )
                        )
                    } catch (ignore: Exception) {
                    }
                }
            }), "Android")
        }

        binding?.tvTime?.setData(iChatCustomFormItem?.date)
    }
}