package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewItemFaqConflictBinding
import ai.engagely.openbot.model.pojos.internal.chat.IChatConflictItem
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class ItemFaqConflictView : FrameLayout {

    private var binding: ViewItemFaqConflictBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewItemFaqConflictBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(
        faqConflictItem: IChatConflictItem?,
        themeColor: Int,
        onClickListener: OnClickListener
    ) {
        binding?.tvConflictMessage?.text = faqConflictItem?.message

        binding?.llFaqs?.removeAllViews()
        faqConflictItem?.faqList?.forEach {
            val verticalSpaceView = VerticalSpaceView(context)
            binding?.llFaqs?.addView(verticalSpaceView)

            val faq = ItemFaqConflictChildView(context)
            faq.setData(it, onClickListener)
            binding?.llFaqs?.addView(faq)
        }

        binding?.vTopStrip?.setBackgroundColor(themeColor)
    }
}