package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewItemMessageTimeBinding
import ai.engagely.openbot.model.utils.general.DateUtils
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout
import java.util.*

class ItemMessageTimeView : FrameLayout {

    private var binding: ViewItemMessageTimeBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewItemMessageTimeBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(date: Date?, hideTime: Boolean? = false) {
        if (hideTime == true) {
            binding?.rootText?.visibility = GONE
            return
        }
        date?.let {
            binding?.rootText?.text = DateUtils.convertFromLocalDateToTime(it).lowercase()
            binding?.rootText?.visibility = VISIBLE
        } ?: run {
            binding?.rootText?.visibility = GONE
        }
    }
}