package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewItemVideoBinding
import ai.engagely.openbot.model.pojos.internal.chat.IVideoItem
import ai.engagely.openbot.model.utils.exts.obtainNonBlankOrNull
import ai.engagely.openbot.model.utils.general.ImageUtils
import android.content.Context
import android.util.AttributeSet
import android.util.TypedValue
import android.view.LayoutInflater
import android.widget.FrameLayout
import android.widget.LinearLayout
import android.widget.RelativeLayout

class ItemVideoView : FrameLayout {

    private var binding: ViewItemVideoBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewItemVideoBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(iVideoItem: IVideoItem?, onItemClickListener: OnClickListener) {
        binding?.ivBanner?.let { imageView ->
            iVideoItem?.url?.let { url ->
                ImageUtils.loadImage(context, url, imageView)
            }
        }

        if (iVideoItem?.hideDetails == true) {
            binding?.tvTitle?.visibility = GONE
            binding?.tvDescription?.visibility = GONE
            binding?.tvVideoText?.visibility = GONE
            binding?.videoInfoBottomSpace?.visibility = GONE
        } else {
            iVideoItem?.title.obtainNonBlankOrNull()?.let { title ->
                binding?.tvTitle?.visibility = VISIBLE
                binding?.tvTitle?.text = title
                binding?.videoInfoBottomSpace?.visibility = VISIBLE
            } ?: kotlin.run {
                binding?.tvTitle?.visibility = GONE
            }
            iVideoItem?.description.obtainNonBlankOrNull()?.let { description ->
                binding?.tvDescription?.visibility = VISIBLE
                binding?.tvDescription?.text = description
                binding?.videoInfoBottomSpace?.visibility = VISIBLE
            } ?: kotlin.run {
                binding?.tvDescription?.visibility = GONE
            }
            iVideoItem?.videoText.obtainNonBlankOrNull()?.let { videoText ->
                binding?.tvVideoText?.visibility = VISIBLE
                binding?.tvVideoText?.text = videoText
                binding?.videoInfoBottomSpace?.visibility = VISIBLE
            } ?: kotlin.run {
                binding?.tvVideoText?.visibility = GONE
            }
        }

        binding?.btPlay?.tag = iVideoItem
        binding?.btPlay?.setOnClickListener(onItemClickListener)

        binding?.tvTime?.setData(iVideoItem?.date)

        if (iVideoItem?.hideSideSpaces == true) {
            binding?.vLeftSpacing?.visibility = GONE
            binding?.vRightSpacing?.visibility = GONE
            binding?.tvTime?.visibility = GONE
            setMainContainerWeight(1f)
        } else {
            val isUserItem = iVideoItem?.isBotItem == false
            binding?.vLeftSpacing?.visibility = if (isUserItem) VISIBLE else GONE
            binding?.vRightSpacing?.visibility = if (isUserItem) GONE else VISIBLE
            setMainContainerWeight(TypedValue().also {
                resources.getValue(R.dimen.chat_bubble_width_fraction, it, true)
            }.float)

            binding?.tvTime?.layoutParams = RelativeLayout.LayoutParams(
                RelativeLayout.LayoutParams.WRAP_CONTENT,
                RelativeLayout.LayoutParams.WRAP_CONTENT
            ).apply {
                addRule(if (isUserItem) RelativeLayout.ALIGN_PARENT_END else RelativeLayout.ALIGN_PARENT_START)
            }
        }
    }

    private fun setMainContainerWeight(weight: Float) {
        (binding?.vMainContainer?.layoutParams as? LinearLayout.LayoutParams)?.let { layoutParams ->
            layoutParams.weight = weight
            binding?.vMainContainer?.layoutParams = layoutParams
        }
    }
}