package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewMultipleOptionHeaderItemBinding
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class MultipleOptionsHeaderView : FrameLayout {

    private var binding: ViewMultipleOptionHeaderItemBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding =
            ViewMultipleOptionHeaderItemBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(header: String?) {
        binding?.tvHeader?.text = header
    }
}