package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewMultipleOptionsWithHeaderBinding
import ai.engagely.openbot.model.pojos.internal.chat.IMultipleOptionsItem
import ai.engagely.openbot.model.utils.exts.obtainNonBlankOrNull
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class MultipleOptionsWithHeaderView : FrameLayout {

    private var binding: ViewMultipleOptionsWithHeaderBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding =
            ViewMultipleOptionsWithHeaderBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(data: IMultipleOptionsItem?, itemClickListener: OnClickListener) {
        binding?.llMultipleOptionsContainer?.removeAllViews()

        val multipleOptionsHeaderView = MultipleOptionsHeaderView(context)
        multipleOptionsHeaderView.setData(
            data?.optionsHeader?.obtainNonBlankOrNull()
                ?: resources.getString(R.string.what_would_you_like_to_do)
        )
        binding?.llMultipleOptionsContainer?.addView(multipleOptionsHeaderView)
        binding?.llMultipleOptionsContainer?.addView(HorizontalDividerView(context))

        data?.options?.forEachIndexed { index, chatItemOption ->
            val chatItemView = MultipleOptionsItemView(context = context)
            chatItemView.setData(chatItemOption.name, chatItemOption.isNew)
            chatItemView.tag = chatItemOption.optionObject
            chatItemView.setOnClickListener(itemClickListener)
            if (index > 0) {
                binding?.llMultipleOptionsContainer?.addView(HorizontalDividerView(context))
            }
            binding?.llMultipleOptionsContainer?.addView(chatItemView)
        }
    }
}