package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewExoplayerMoreMenuBinding
import android.content.Context
import android.util.AttributeSet
import android.view.Gravity
import android.view.LayoutInflater
import android.widget.FrameLayout
import android.widget.PopupMenu

class PlayerMoreMenuView : FrameLayout {

    private var binding: ViewExoplayerMoreMenuBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewExoplayerMoreMenuBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(playerMoreMenuClickListener: PlayerMoreMenuClickListener) {
        binding?.ibMore?.setOnClickListener { clickedView ->
            val popupMenu = PopupMenu(context, clickedView, Gravity.END)
            popupMenu.menuInflater.inflate(R.menu.video_player_menu, popupMenu.menu)

            popupMenu.show()
            popupMenu.setOnMenuItemClickListener {
                if (it.itemId == R.id.menu_download) {
                    playerMoreMenuClickListener.onDownloadMenuSelected()
                }
                true
            }
        }
    }

    interface PlayerMoreMenuClickListener {
        fun onDownloadMenuSelected()
    }
}