package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.model.pojos.internal.chat.ITabularInfoItem
import ai.engagely.openbot.model.pojos.internal.common.ISubmitTabularResponse
import android.content.Context
import android.util.AttributeSet
import android.widget.FrameLayout
import android.widget.LinearLayout
import com.google.android.material.card.MaterialCardView

abstract class TabularInfoBaseView : FrameLayout {

    constructor(context: Context) : super(context)

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs)

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    )

    protected fun setData(
        tabularItemsContainer: LinearLayout?,
        timeText: ItemMessageTimeView?,
        bgCard: MaterialCardView?,
        actionButton: BotChatBubbleActionButtonView?,
        tabularInfoItem: ITabularInfoItem?,
        textColor: Int,
        bgColor: Int,
        onClickListener: OnClickListener
    ) {
        tabularItemsContainer?.removeAllViews()

        var showSubmit = tabularInfoItem?.enableSubmit == true
        tabularInfoItem?.childItems?.forEach {
            val verticalSpaceView = VerticalSpaceView(context)
            tabularItemsContainer?.addView(verticalSpaceView)

            val tabularSpinnerView = TabularSpinnerView(context)
            tabularSpinnerView.setData(tabularInfoItem, it, textColor, onClickListener)
            tabularItemsContainer?.addView(tabularSpinnerView)

            if (it.selectedPosition == 0) {
                showSubmit = false
            }
        }

        val verticalSpaceView = VerticalSpaceView(context)
        tabularItemsContainer?.addView(verticalSpaceView)

        actionButton?.setData(
            buttonName = tabularInfoItem?.responseParams?.submit,
            tag = ISubmitTabularResponse(tabularInfoItem),
            enabled = showSubmit,
            isLoading = tabularInfoItem?.isLoading ?: false,
            onClickListener = onClickListener
        )

        bgCard?.setCardBackgroundColor(bgColor)
        timeText?.setData(tabularInfoItem?.date)
    }
}