package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewTabularSpinnerBinding
import ai.engagely.openbot.model.pojos.internal.chat.ITabularDropDownItem
import ai.engagely.openbot.model.pojos.internal.chat.ITabularInfoChildItem
import ai.engagely.openbot.model.pojos.internal.chat.ITabularInfoItem
import android.content.Context
import android.graphics.Color
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.AdapterView
import android.widget.ArrayAdapter
import android.widget.FrameLayout
import android.widget.TextView

class TabularSpinnerView : FrameLayout {

    private var binding: ViewTabularSpinnerBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewTabularSpinnerBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(
        tabularInfoItem: ITabularInfoItem,
        iTabularInfoChildItem: ITabularInfoChildItem?,
        textColor: Int,
        onClickListener: OnClickListener
    ) {
        binding?.tvLabel?.text = iTabularInfoChildItem?.heading
        binding?.tvLabel?.setTextColor(textColor)

        var showSelect = false
        iTabularInfoChildItem?.items?.first()?.apply {
            if (enVal == null && transVal == null) {
                enVal = context.getString(R.string.select)
                showSelect = true
            }
        }

        iTabularInfoChildItem?.items?.let {
            val adapter = object : ArrayAdapter<ITabularDropDownItem>(
                context,
                R.layout.view_spinner_selected_item,
                it
            ) {
                override fun isEnabled(position: Int): Boolean {
                    // Disable the first item from Spinner
                    // First item will be used for hint
                    return position != 0
                }

                override fun getDropDownView(
                    position: Int,
                    convertView: View?,
                    parent: ViewGroup
                ): View {
                    val view: TextView =
                        super.getDropDownView(position, convertView, parent) as TextView
                    setTextColorForPosition(position, view)
                    return view
                }
            }
            adapter.setDropDownViewResource(R.layout.view_spinner_dopdown_item)
            binding?.spinner?.adapter = adapter
            binding?.spinner?.setSelection(iTabularInfoChildItem.selectedPosition, false)
            if (showSelect) {
                setTextColorForPosition(
                    iTabularInfoChildItem.selectedPosition,
                    binding?.spinner?.selectedView
                )
            }
            binding?.spinner?.onItemSelectedListener = object : AdapterView.OnItemSelectedListener {
                override fun onItemSelected(
                    parent: AdapterView<*>?,
                    view: View?,
                    position: Int,
                    id: Long
                ) {
                    setTextColorForPosition(position, view)

                    iTabularInfoChildItem.selectedPosition = position

                    val selectedItem = iTabularInfoChildItem.items?.get(position)

                    view?.tag = selectedItem
                    view?.setTag(R.id.tabular_item, tabularInfoItem)
                    view?.setTag(R.id.tabular_item_child, iTabularInfoChildItem)

                    onClickListener.onClick(view)
                }

                override fun onNothingSelected(adapter: AdapterView<*>?) {
                    //Nothing to do
                }
            }
        }

        binding?.progressBar?.visibility = if (iTabularInfoChildItem?.isLoading == true) {
            VISIBLE
        } else {
            GONE
        }
    }

    private fun setTextColorForPosition(position: Int, view: View?) {
        (view as? TextView)?.let {
            if (position == 0) {
                it.setTextColor(Color.GRAY)
            } else {
                it.setTextColor(Color.BLACK)
            }
        }
    }
}