package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.model.pojos.internal.chat.ITabularValueItem
import android.content.Context
import android.util.AttributeSet
import android.widget.FrameLayout
import android.widget.LinearLayout
import androidx.cardview.widget.CardView
import androidx.core.content.ContextCompat
import com.google.android.gms.maps.MapView
import com.google.android.material.card.MaterialCardView

abstract class TabularValueBaseView : FrameLayout {

    constructor(context: Context) : super(context)

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs)

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    )

    fun setData(
        rlMessageContainer: MaterialCardView?,
        cvInnerContainer: CardView?,
        llTabularValues: LinearLayout?,
        mapViewLight: MapView?,
        vMapDivider: HorizontalDividerView?,
        tvTime: ItemMessageTimeView?,
        tabularValueItem: ITabularValueItem?,
        textColor: Int,
        bgColor: Int
    ) {
        rlMessageContainer?.setCardBackgroundColor(bgColor)
        cvInnerContainer?.setCardBackgroundColor(bgColor)

        if (tabularValueItem?.latitude != null && tabularValueItem.longitude != null) {
            mapViewLight?.visibility = VISIBLE
            vMapDivider?.visibility = VISIBLE
            vMapDivider?.setColor(
                ContextCompat.getColor(
                    context,
                    R.color.tabular_value_border
                )
            )
        } else {
            mapViewLight?.visibility = GONE
            vMapDivider?.visibility = GONE
        }

        llTabularValues?.removeAllViews()
        var noOfItemsToBeAdded = tabularValueItem?.values?.size ?: 0
        tabularValueItem?.values?.forEach {
            val tabularValueItemView = TabularValueItemView(context)
            tabularValueItemView.setData(it.key, it.value, textColor)
            llTabularValues?.addView(tabularValueItemView)

            if (--noOfItemsToBeAdded > 0) {
                val horizontalDividerView = HorizontalDividerView(context)
                horizontalDividerView.setColor(
                    ContextCompat.getColor(
                        context,
                        R.color.tabular_value_border
                    )
                )
                llTabularValues?.addView(horizontalDividerView)
            }
        }

        tvTime?.setData(tabularValueItem?.date)
    }

}