package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewTabularValueBinding
import ai.engagely.openbot.model.pojos.internal.chat.ITabularValueItem
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater

class TabularValueView : TabularValueBaseView {

    private var binding: ViewTabularValueBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewTabularValueBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(tabularValueItem: ITabularValueItem?, textColor: Int, bgColor: Int) {
        setData(
            binding?.rlMessageContainer,
            binding?.cvInnerContainer,
            binding?.llTabularValues,
            binding?.mapViewLight,
            binding?.vMapDivider,
            binding?.tvTime,
            tabularValueItem,
            textColor,
            bgColor
        )
    }
}