package ai.engagely.openbot.model.utils.javascriptinterfaces

import android.webkit.JavascriptInterface

class CustomFormJavascriptInterface(private val listener: JavascriptEventListener) {

    @JavascriptInterface
    fun changeLanguage(newLanguageCode: String) {
        listener.changeLanguage(newLanguageCode)
    }

    @JavascriptInterface
    fun startQuickJourney(journeyName: String, fieldText: String) {
        listener.startQuickJourney(journeyName, fieldText)
    }

    interface JavascriptEventListener {

        fun changeLanguage(newLanguageCode: String)

        fun startQuickJourney(journeyName: String, fieldText: String)
    }
}