package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewFaqAutoCompleteBinding
import ai.engagely.openbot.model.pojos.internal.faqautocomplete.IFaqAutoCompleteItem
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class FaqAutoCompleteView : FrameLayout {

    private var binding: ViewFaqAutoCompleteBinding? = null
    private var isLoading = false

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewFaqAutoCompleteBinding.inflate(LayoutInflater.from(context), this, true)
        visibility = GONE
    }

    fun setIsLoading(isLoading: Boolean) {
        this.isLoading = isLoading
        sycLoadingState()
    }

    private fun sycLoadingState() {
        if (isLoading) {
            visibility = VISIBLE
            binding?.cvAutoComplete?.visibility = GONE
            binding?.pbLoader?.visibility = VISIBLE
        } else {
            binding?.pbLoader?.visibility = GONE
            binding?.cvAutoComplete?.visibility = VISIBLE
        }
    }

    fun setData(
        iFaqAutoCompleteItems: List<IFaqAutoCompleteItem>?,
        onClickListener: OnClickListener
    ) {
        if (iFaqAutoCompleteItems.isNullOrEmpty()) {
            visibility = GONE
            return
        }

        binding?.llAutoComplete?.removeAllViews()
        iFaqAutoCompleteItems.forEach {
            val question = FaqAutoCompleteItemView(context)
            question.setData(it.question)
            question.tag = it
            question.setOnClickListener(onClickListener)
            binding?.llAutoComplete?.addView(question)

            val divider = HorizontalDividerView(context)
            binding?.llAutoComplete?.addView(divider)
        }

        visibility = VISIBLE
        sycLoadingState()
    }
}