package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewFormDateBinding
import ai.engagely.openbot.model.pojos.internal.history.IFormDateItem
import ai.engagely.openbot.model.pojos.internal.history.IFormItem
import ai.engagely.openbot.model.utils.general.DateUtils
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class FormDateVIew : FrameLayout {

    private var binding: ViewFormDateBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewFormDateBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(iFormDateItem: IFormDateItem, dateClickListener: OnClickListener) {
        binding?.tvLabel?.text = iFormDateItem.labelName

        iFormDateItem.selectedDate?.let {
            binding?.etDate?.setText(DateUtils.convertFromLocalDateToDateString(it))
        }

        binding?.etDate?.tag = iFormDateItem
        binding?.etDate?.setTag(R.id.tag_form_date, this)
        binding?.etDate?.setOnClickListener(dateClickListener)
        setError(iFormDateItem)
    }

    private fun setError(iFormItem: IFormItem) {
        binding?.tvError?.visibility =
            if (!iFormItem.errorMessage.isNullOrBlank()) VISIBLE else GONE
        binding?.tvError?.text = iFormItem.errorMessage
    }
}