package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewItemFaqConflictChildBinding
import ai.engagely.openbot.model.pojos.internal.chat.IChatConflictChildItem
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class ItemFaqConflictChildView : FrameLayout {

    private var binding: ViewItemFaqConflictChildBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewItemFaqConflictChildBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(iChatConflictChildItem: IChatConflictChildItem, onClickListener: OnClickListener) {
        binding?.tvClickable?.text = iChatConflictChildItem.question
        binding?.tvClickable?.tag = iChatConflictChildItem
        binding?.tvClickable?.setOnClickListener(onClickListener)
    }
}