package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewItemMessagesItemBinding
import ai.engagely.openbot.model.utils.general.LogUtils
import android.content.Context
import android.text.method.LinkMovementMethod
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout
import androidx.core.text.parseAsHtml

class ItemMessagesItemView : FrameLayout {

    private var binding: ViewItemMessagesItemBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewItemMessagesItemBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(message: String, textColor: Int, isHtml: Boolean) {
        if (isHtml) {
            binding?.tvMessage?.text = try {
                message.parseAsHtml().trimEnd()
            } catch (e: Exception) {
                LogUtils.logException(e)
                message
            }
            binding?.tvMessage?.movementMethod = LinkMovementMethod.getInstance()
        } else {
            binding?.tvMessage?.text = message
            binding?.tvMessage?.movementMethod = null
        }
        binding?.tvMessage?.setTextColor(textColor)
    }
}